$(document).ready(function()
{
	common.show_main_view_intreface()
	common.show_errors_info()
	common.show_dump_button()

	const mcu_common_script = utils.load_script('mcu_common.js')
	const network_settings_script = utils.load_script('network_settings.js')
	const one_wire_script = utils.load_script('one_wire.js')
	const app_sw_control_script = utils.load_script('app_sw_control.js')
    const app_sw_script = utils.load_script('app_sw.js')
    Promise.all([
		mcu_common_script,
		network_settings_script,
		one_wire_script,
		app_sw_control_script,
		app_sw_script
	])
	.then(() => app_sw_control.main())
	.then(() => app_sw.main())
	.then(() => mcu_common.request_board_types())
	.then(text => common.response_ready(text))
	.then(values => async function(values) {
		let product_code = values[0]
		let types = values.slice(1)
		let product_code_arr = get_set_value.ip2array(product_code)
		mcu_common.show_boards_types_setting()
		mcu_common.show_boards_by_type(types, product_code_arr)
		await network_settings.show("old")
	}(values))
	.then(() => one_wire.get_sensors_data())
	.then(data => one_wire.show(data.ids, data.sensors_count))
	.then(() => {
		common.on_page_loading_finished()
		user.parse_page()
	})
})

